<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-25 16:37:03
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Supplier
 * @method checkCardNumberExistByParams(array $params) 校验银行卡号是否存在
 * @method createSupplierByParams(array $params) 创建供应商
 * @method updateSupplierByParams(array $params) 更新供应商
 * @method getSupplierListByParams(array $params) 获取供应商列表--银行信息拉平
 * @method getSupplierListWithBankByParams(array $params) 获取供应商列表--子节点银行信息
 * @method getSupplierDetailByParams(array $params) 获取供应商信息
 * @method createBankByParams(array $params) 创建银行
 * @method updateBankByParams(array $params) 更新银行
 * @method getBankListByParams(array $params) 获取银行列表
 * @method getBranchBankListByParams(array $params) 获取指定数量的支行列表
 * @method getBankDetailByParams(array $params) 获取银行详情
 */
class Supplier {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\Supplier";

    /**
     * 校验银行卡号是否存在
     * @return  array
    */
    public static function checkCardNumberExist (array $cardNumbers) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkCardNumberExist(["cardNumbers" => $cardNumbers]);
    }
    /**
     * 创建供应商
     * @return  bool
    */
    public static function createSupplier (string $name, string $type, string $taxType, string $creditCode, array $creditImage, int $director, array $banks) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSupplier(["name" => $name, "type" => $type, "taxType" => $taxType, "creditCode" => $creditCode, "creditImage" => $creditImage, "director" => $director, "banks" => $banks]);
    }
    /**
     * 更新供应商
     * @return  bool
    */
    public static function updateSupplier (int $id, string $name, string $type, string $taxType, string $creditCode, array $creditImage, int $director, array $banks) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSupplier(["id" => $id, "name" => $name, "type" => $type, "taxType" => $taxType, "creditCode" => $creditCode, "creditImage" => $creditImage, "director" => $director, "banks" => $banks]);
    }
    /**
     * 获取供应商列表--银行信息拉平
     * @return  array
    */
    public static function getSupplierList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplierList([]);
    }
    /**
     * 获取供应商列表--子节点银行信息
     * @return  array
    */
    public static function getSupplierListWithBank () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplierListWithBank([]);
    }
    /**
     * 获取供应商信息
     * @return  array
    */
    public static function getSupplierDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplierDetail(["id" => $id]);
    }
    /**
     * 创建银行
     * @return  bool
    */
    public static function createBank (string $name, string $bank_number, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createBank(["name" => $name, "bank_number" => $bank_number, "type" => $type]);
    }
    /**
     * 更新银行
     * @return  bool
    */
    public static function updateBank (int $id, string $name, string $bank_number, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBank(["id" => $id, "name" => $name, "bank_number" => $bank_number, "type" => $type]);
    }
    /**
     * 获取银行列表
     * @return  array
    */
    public static function getBankList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBankList([]);
    }
    /**
     * 获取指定数量的支行列表
     * @return  array
    */
    public static function getBranchBankList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBranchBankList([]);
    }
    /**
     * 获取银行详情
     * @return  array
    */
    public static function getBankDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBankDetail(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}