<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-26 15:43:41
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Ovopark
 * @method searchStaffByKeywordByParams(array $params) 根据关键词限定搜索用户
 * @method getStaffDepartmentsListByParams(array $params) 用户权限列表
 * @method getStaffDepartmentsDetailByParams(array $params) 用户权限详情
 * @method updateOrCreateStaffDepartmentsByParams(array $params) 新建/更新人员万店掌权限
 * @method deleteStaffDepartmentsByParams(array $params) 删除人员万店掌权限
 * @method checkStaffDepartmentsByParams(array $params) 检查是否有存在权限
 */
class Ovopark {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\Ovopark";

    /**
     * 根据关键词限定搜索用户
     * @return  array
    */
    public static function searchStaffByKeyword () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaffByKeyword([]);
    }
    /**
     * 用户权限列表
     * @return  array
    */
    public static function getStaffDepartmentsList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffDepartmentsList([]);
    }
    /**
     * 用户权限详情
     * @return  array
    */
    public static function getStaffDepartmentsDetail (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffDepartmentsDetail(["staffId" => $staffId]);
    }
    /**
     * 新建/更新人员万店掌权限
     * @return  bool
    */
    public static function updateOrCreateStaffDepartments (int $staffId, array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrCreateStaffDepartments(["staffId" => $staffId, "departmentIds" => $departmentIds]);
    }
    /**
     * 删除人员万店掌权限
     * @return  bool
    */
    public static function deleteStaffDepartments (array $staffDepartmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStaffDepartments(["staffDepartmentIds" => $staffDepartmentIds]);
    }
    /**
     * 检查是否有存在权限
     * @return  array
    */
    public static function checkStaffDepartments (int $staffId, array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkStaffDepartments(["staffId" => $staffId, "departmentIds" => $departmentIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}