<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-14 11:41:27
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\Staff";

    /**
     * 根据工号获取伙伴周年和生日信息
     * @return  array
    */
    public static function getDaysByStaffIds (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDaysByStaffIds(["staffIds" => $staffIds]);
    }
    /**
     * 根据部门id获取排班信息
     * @return  array
    */
    public static function getSchedules (int $departmentId, int $staffId, string $startDate, string $endDate, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSchedules(["departmentId" => $departmentId, "staffId" => $staffId, "startDate" => $startDate, "endDate" => $endDate, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 根据工号判断伙伴是否是海马体正式员工
     * @return  bool
    */
    public static function hasAnniversaryCard (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasAnniversaryCard(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}