<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-04 17:40:01
 */
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Supplier
 */
class Supplier {
    private static string $serviceName = "HimoEbsV2";

    private static string $className = "Inside\\Supplier";

    /**
     * 校验银行卡号是否存在
     * @return  array
    */
    public static function checkCardNumberExist (array $cardNumbers, array $bankIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkCardNumberExist(["cardNumbers" => $cardNumbers, "bankIds" => $bankIds]);
    }
    /**
     * 创建供应商
     * @return  bool
    */
    public static function createSupplier (string $name, string $type, string $taxType, string $creditCode, array $creditImage, int $director, string $phone = '', string $contact = '', string $province = '', string $city = '', string $area = '', string $address = '', string $prepaidRate = '0.00', bool $status, array $banks) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSupplier(["name" => $name, "type" => $type, "taxType" => $taxType, "creditCode" => $creditCode, "creditImage" => $creditImage, "director" => $director, "phone" => $phone, "contact" => $contact, "province" => $province, "city" => $city, "area" => $area, "address" => $address, "prepaidRate" => $prepaidRate, "status" => $status, "banks" => $banks]);
    }
    /**
     * 更新供应商
     * @return  bool
    */
    public static function updateSupplier (int $id, string $name, string $type, string $taxType, string $creditCode, array $creditImage, int $director, string $contact, string $phone, string $province, string $city, string $area, string $address, string $prepaidRate = '0.00', bool $status, array $banks) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSupplier(["id" => $id, "name" => $name, "type" => $type, "taxType" => $taxType, "creditCode" => $creditCode, "creditImage" => $creditImage, "director" => $director, "contact" => $contact, "phone" => $phone, "province" => $province, "city" => $city, "area" => $area, "address" => $address, "prepaidRate" => $prepaidRate, "status" => $status, "banks" => $banks]);
    }
    /**
     * 获取供应商列表--银行信息拉平
     * @return  array
    */
    public static function getSupplierList (string $name, string $cardNumber, string $type, bool $status, string $payType, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplierList(["name" => $name, "cardNumber" => $cardNumber, "type" => $type, "status" => $status, "payType" => $payType, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取供应商列表--子节点银行信息
     * @return  array
    */
    public static function getSupplierListWithBank (int $id, string $name, string $type, bool $status, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplierListWithBank(["id" => $id, "name" => $name, "type" => $type, "status" => $status, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取供应商信息
     * @return  array
    */
    public static function getSupplierDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplierDetail(["id" => $id]);
    }
    /**
     * 创建银行
     * @return  bool
    */
    public static function createBank (string $name, string $bank_number, string $type, int $parent_id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createBank(["name" => $name, "bank_number" => $bank_number, "type" => $type, "parent_id" => $parent_id]);
    }
    /**
     * 更新银行
     * @return  bool
    */
    public static function updateBank (int $id, string $name, string $bank_number, string $type, int $parent_id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBank(["id" => $id, "name" => $name, "bank_number" => $bank_number, "type" => $type, "parent_id" => $parent_id]);
    }
    /**
     * 获取银行列表
     * @return  array
    */
    public static function getBankList (string $name, string $type, int $page = 0, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBankList(["name" => $name, "type" => $type, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取指定数量的支行列表
     * @return  array
    */
    public static function getBranchBankList (string $name, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBranchBankList(["name" => $name, "pageSize" => $pageSize]);
    }
    /**
     * 获取银行详情
     * @return  array
    */
    public static function getBankDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBankDetail(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}