<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty\ThirdPlatformOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method thirdOrderCodeListByParams(array $params)
 */
class ThirdOrderManager {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 第三方订单券码查询
     *
     * @support  string $thirdType 第三方订单类型 [ require false ]
     * @support  string $thirdOrderId 第三方订单ID [ require false ]
     * @support  string $code 券码 [ require false ]
     * @param  int $page 页数 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function thirdOrderCodeList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->thirdOrderCodeList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'ThirdParty\ThirdPlatformOrder\ThirdOrderManager');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'ThirdParty\ThirdPlatformOrder\ThirdOrderManager');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}