<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncFinishTripByParams(array $params)
 * @method syncCancelTripByParams(array $params)
 */
class Erp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步完成出差单
     *
     * @param  string $tripNo 审批单号 [ require true ]
     * @param  int $staffId 工号 [ require false ]
     * @param  string $classCode 出差or外出 [ require false ]
     * @param  string $type 类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncFinishTrip (string $tripNo, int $staffId = 0, string $classCode = '', string $type = 'all') {
        return self::getClass()->syncFinishTrip([
            "tripNo" => $tripNo,
            "staffId" => $staffId,
            "classCode" => $classCode,
            "type" => $type,
        ]);
    }

    /**
     * 同步撤销出差单
     *
     * @param  string $tripNo 审批单号 [ require true ]
     * @param  int $staffId 工号 [ require false ]
     * @param  string $classCode 出差or外出 [ require false ]
     * @param  string $type 类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncCancelTrip (string $tripNo, int $staffId = 0, string $classCode = '', string $type = 'all') {
        return self::getClass()->syncCancelTrip([
            "tripNo" => $tripNo,
            "staffId" => $staffId,
            "classCode" => $classCode,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\Erp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\Erp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}