<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty\ThirdPlatformOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tmallNotifyByParams(array $params)
 * @method generateCodeToMQByParams(array $params)
 * @method uploadCodeByParams(array $params)
 * @method resendCodeToMQByParams(array $params)
 * @method resendCodeByParams(array $params)
 * @method useCodeToMQByParams(array $params)
 * @method consumeCodeByParams(array $params)
 * @method refundByParams(array $params)
 * @method confirmRefundByParams(array $params)
 */
class TMallOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 天猫通知接口
     *
     * @throws  \Exception
     * @return  string
     */
    public static function tmallNotify () {
        return self::getClass()->tmallNotify();
    }

    /**
     * 生成券码信息至mq
     *
     * @param  mixed $content 通知信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function generateCodeToMQ ($content) {
        return self::getClass()->generateCodeToMQ([
            "content" => $content,
        ]);
    }

    /**
     * 上传券码至天猫
     *
     * @param  mixed $content 通知信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function uploadCode ($content) {
        return self::getClass()->uploadCode([
            "content" => $content,
        ]);
    }

    /**
     * 重新生成发码信息至MQ
     *
     * @param  mixed $content 通知信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resendCodeToMQ ($content) {
        return self::getClass()->resendCodeToMQ([
            "content" => $content,
        ]);
    }

    /**
     * 重新发码至天猫
     *
     * @param  mixed $content 通知信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function resendCode ($content) {
        return self::getClass()->resendCode([
            "content" => $content,
        ]);
    }

    /**
     * 使用券码通知
     *
     * @param  string $code 券码 [ require true ]
     * @support  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function useCodeToMQ (string $code) {
        return self::getClass()->useCodeToMQ([
            "code" => $code,
        ]);
    }

    /**
     * 电子凭证核销接口
     *
     * @param  mixed $content 通知信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function consumeCode ($content) {
        return self::getClass()->consumeCode([
            "content" => $content,
        ]);
    }

    /**
     * 通知码商维权成功|通知码商退款成功
     *
     * @param  mixed $content 通知信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund ($content) {
        return self::getClass()->refund([
            "content" => $content,
        ]);
    }

    /**
     * 确认退款
     *
     * @param  array $content 退款列表信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmRefund (array $content) {
        return self::getClass()->confirmRefund([
            "content" => $content,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'ThirdParty\ThirdPlatformOrder\TMallOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'ThirdParty\ThirdPlatformOrder\TMallOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}