<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeisenStaffByParams(array $params)
 * @method syncStaffToGaiaByParams(array $params)
 * @method syncStaffUpdatePhoneByParams(array $params)
 * @method syncStaffEventByParams(array $params)
 * @method batchCreateNasStaffByParams(array $params)
 * @method batchDeleteNasStaffByParams(array $params)
 * @method batchLeaveByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method restoreStaffDepartmentsByParams(array $params)
 * @method batchCreateOvoparkStaffByParams(array $params)
 * @method syncDttripStaffByParams(array $params)
 * @method syncStaffCreateByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步指定北森员工
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeisenStaff (int $staffId) {
        return self::getClass()->syncBeisenStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 同步指定员工到gaia
     *
     * @param  array $staffIds 工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStaffToGaia (array $staffIds) {
        return self::getClass()->syncStaffToGaia([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 同步伙伴手机号变更
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $newPhone 新手机号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function syncStaffUpdatePhone (int $staffId, string $newPhone) {
        return self::getClass()->syncStaffUpdatePhone([
            "staffId" => $staffId,
            "newPhone" => $newPhone,
        ]);
    }

    /**
     * 同步指定员工事件到指定服务或第三方
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $action 操作。新增：create;更新：update;删除：delete；重新入职：restore [ require false ]
     * @param  array $services 指定服务或第三方 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function syncStaffEvent (int $staffId, string $action = 'create', array $services = []) {
        return self::getClass()->syncStaffEvent([
            "staffId" => $staffId,
            "action" => $action,
            "services" => $services,
        ]);
    }

    /**
     * 批量创建NAS账号
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreateNasStaff (array $staffIds) {
        return self::getClass()->batchCreateNasStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量删除NAS账号
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDeleteNasStaff (array $staffIds) {
        return self::getClass()->batchDeleteNasStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量离职
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchLeave (array $staffIds) {
        return self::getClass()->batchLeave([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量入职
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreate (array $staffIds) {
        return self::getClass()->batchCreate([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate (array $staffIds) {
        return self::getClass()->batchUpdate([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 重新绑定人员部门关系
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  int $departmentId 部门id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function restoreStaffDepartments (int $staffId, int $departmentId) {
        return self::getClass()->restoreStaffDepartments([
            "staffId" => $staffId,
            "departmentId" => $departmentId,
        ]);
    }

    /**
     * 添加万店掌用户表
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  int $userId 万店掌用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreateOvoparkStaff (int $staffId, int $userId) {
        return self::getClass()->batchCreateOvoparkStaff([
            "staffId" => $staffId,
            "userId" => $userId,
        ]);
    }

    /**
     * 同步指定员工信息到同程
     *
     * @param  array $staffIds 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function syncDttripStaff (array $staffIds) {
        return self::getClass()->syncDttripStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 添加人员到测试企业
     *
     * @support  int $staffId 工号 [ require true ]
     * @support  string $phone 电话 [ require true ]
     * @support  string $name 姓名 [ require true ]
     * @support  string $nickname 昵称 [ require true ]
     * @support  int $departmentId 部门 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStaffCreate () {
        return self::getClass()->syncStaffCreate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}