<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitPaymentByParams(array $params)
 * @method getCallBackByParams(array $params)
 * @method editPaymentStatusByParams(array $params)
 */
class Payment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交支付
     *
     * @param  array $data 支付单信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitPayment (array $data) {
        return self::getClass()->submitPayment([
            "data" => $data,
        ]);
    }

    /**
     * 获取结果
     *
     * @param  int $id 支付单Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getCallBack (int $id) {
        return self::getClass()->getCallBack([
            "id" => $id,
        ]);
    }

    /**
     * 获取结果
     *
     * @param  array $ids 支付单Id [ require true ]
     * @param  string $status 支付状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editPaymentStatus (array $ids, string $status) {
        return self::getClass()->editPaymentStatus([
            "ids" => $ids,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\Payment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\Payment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}