<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncStaffByParams(array $params)
 */
class Dttrip {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步员工信息
     *
     * @param  string $start 开始时间 [ require false ]
     * @param  string $end 结束时间 [ require false ]
     * @param  bool $isAll 同步全量 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStaff (string $start = '', string $end = '', bool $isAll = false) {
        return self::getClass()->syncStaff([
            "start" => $start,
            "end" => $end,
            "isAll" => $isAll,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Cron\Dttrip');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Cron\Dttrip');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}