<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncMaycurByParams(array $params)
 * @method cratePaymentByParams(array $params)
 */
class MaycurOpen {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步每刻数据
     *
     * @param  string $reportId 每刻单据号 [ require true ]
     * @support  array $paymentInfo 支付信息 [ require false ]
     * @param  string $type 是否需要支付 [ require true ]
     * @support  string $reportType 数据类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncMaycur (string $reportId, string $type) {
        return self::getClass()->syncMaycur([
            "reportId" => $reportId,
            "type" => $type,
        ]);
    }

    /**
     * 手动拉取每刻数据创建支付
     *
     * @param  string $reportId 每刻单据号 [ require true ]
     * @param  string $reportType 数据类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cratePayment (string $reportId, string $reportType) {
        return self::getClass()->cratePayment([
            "reportId" => $reportId,
            "reportType" => $reportType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\MaycurOpen');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\MaycurOpen');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}