<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method singleLoginByParams(array $params)
 * @method syncTripTicketByParams(array $params)
 */
class Dttrip {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 单点登录
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $plat 平台:h5,pc [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function singleLogin (int $staffId, string $plat) {
        return self::getClass()->singleLogin([
            "staffId" => $staffId,
            "plat" => $plat,
        ]);
    }

    /**
     * syncTripTicket
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncTripTicket () {
        return self::getClass()->syncTripTicket();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'ThirdParty\Dttrip');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'ThirdParty\Dttrip');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}