<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncDepartmentEventByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步指定部门事件到指定服务或第三方
     *
     * @param  int $departmentId 部门id [ require true ]
     * @param  string $action 操作。新增：create;更新：update;删除：delete [ require false ]
     * @param  array $services 指定服务或第三方 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function syncDepartmentEvent (int $departmentId, string $action = 'create', array $services = []) {
        return self::getClass()->syncDepartmentEvent([
            "departmentId" => $departmentId,
            "action" => $action,
            "services" => $services,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}