<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method personalReportByParams(array $params)
 * @method corpReportByParams(array $params)
 * @method consumeReportByParams(array $params)
 * @method repaymentReportByParams(array $params)
 * @method syncOrganizationByParams(array $params)
 * @method syncDepartmentByParams(array $params)
 * @method syncStaffByParams(array $params)
 */
class Maycur {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 对私报销 - 每15分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function personalReport () {
        return self::getClass()->personalReport();
    }

    /**
     * 对公报销 - 每15分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function corpReport () {
        return self::getClass()->corpReport();
    }

    /**
     * 个人借款 - 每15分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeReport () {
        return self::getClass()->consumeReport();
    }

    /**
     * 个人退款 - 每15分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function repaymentReport () {
        return self::getClass()->repaymentReport();
    }

    /**
     * 同步组织员工信息
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncOrganization () {
        return self::getClass()->syncOrganization();
    }

    /**
     * 同步部门
     *
     * @param  string $start 开始时间 [ require false ]
     * @param  string $end 结束时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncDepartment (string $start = '', string $end = '') {
        return self::getClass()->syncDepartment([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 同步员工
     *
     * @param  string $start 开始时间 [ require false ]
     * @param  string $end 结束时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStaff (string $start = '', string $end = '') {
        return self::getClass()->syncStaff([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Cron\Maycur');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Cron\Maycur');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}