<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty\ThirdPlatformOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getPageListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method infoByParams(array $params)
 */
class ThirdSkuBind {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加绑定关系
     *
     * @param  string $thirdSkuId skuid [ require true ]
     * @support  string $goodName 商品名称 [ require true ]
     * @support  int $templateId 产品卡模版ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $thirdSkuId) {
        return self::getClass()->create([
            "thirdSkuId" => $thirdSkuId,
        ]);
    }

    /**
     * 更新绑定关系
     *
     * @param  int $id 主键ID [ require true ]
     * @param  string $thirdSkuId skuid [ require true ]
     * @support  string $goodName 商品名称 [ require true ]
     * @support  int $templateId 产品卡模版ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function update (int $id, string $thirdSkuId) {
        return self::getClass()->update([
            "id" => $id,
            "thirdSkuId" => $thirdSkuId,
        ]);
    }

    /**
     * 商品绑定列表-分页
     *
     * @support  string $thirdSkuId skuid [ require false ]
     * @support  int $templateId 产品卡模版ID [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPageList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPageList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除绑定关系
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取券码绑定详情
     *
     * @param  int $id 主键ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'ThirdParty\ThirdPlatformOrder\ThirdSkuBind');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'ThirdParty\ThirdPlatformOrder\ThirdSkuBind');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}