<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchStaffByKeywordByParams(array $params)
 * @method getStaffDepartmentsListByParams(array $params)
 * @method getStaffDepartmentsDetailByParams(array $params)
 * @method updateOrCreateStaffDepartmentsByParams(array $params)
 * @method deleteStaffDepartmentsByParams(array $params)
 * @method checkStaffDepartmentsByParams(array $params)
 * @method syncRoleByParams(array $params)
 * @method getRoleListByParams(array $params)
 * @method getPositionListByParams(array $params)
 * @method bindRolePositionByParams(array $params)
 * @method unbindRolePositionByParams(array $params)
 */
class Ovopark {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据关键词限定搜索用户
     *
     * @param  string $keyword 搜索关键词 [ require false ]
     * @param  int $limit 限制数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchStaffByKeyword (string $keyword = '', int $limit = 20) {
        return self::getClass()->searchStaffByKeyword([
            "keyword" => $keyword,
            "limit" => $limit,
        ]);
    }

    /**
     * 用户权限列表
     *
     * @param  string $type 搜索关键词类型 [ require false ]
     * @param  string $value 搜索关键词 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffDepartmentsList (string $type = '', string $value = '', int $page = 1, int $pageSize = 20) {
        return self::getClass()->getStaffDepartmentsList([
            "type" => $type,
            "value" => $value,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 用户权限详情
     *
     * @param  int $staffId 搜索关键词类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffDepartmentsDetail (int $staffId) {
        return self::getClass()->getStaffDepartmentsDetail([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 新建/更新人员万店掌权限
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  array $departmentIds 部门ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOrCreateStaffDepartments (int $staffId, array $departmentIds) {
        return self::getClass()->updateOrCreateStaffDepartments([
            "staffId" => $staffId,
            "departmentIds" => $departmentIds,
        ]);
    }

    /**
     * 删除人员万店掌权限
     *
     * @param  mixed $staffDepartmentIds 人员权限数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteStaffDepartments ($staffDepartmentIds) {
        return self::getClass()->deleteStaffDepartments([
            "staffDepartmentIds" => $staffDepartmentIds,
        ]);
    }

    /**
     * 检查是否有存在权限
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  array $departmentIds 部门ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkStaffDepartments (int $staffId, array $departmentIds) {
        return self::getClass()->checkStaffDepartments([
            "staffId" => $staffId,
            "departmentIds" => $departmentIds,
        ]);
    }

    /**
     * 同步万店掌角色
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncRole () {
        return self::getClass()->syncRole();
    }

    /**
     * 获取万店掌角色列表
     *
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @param  string $roleName 万店掌角色名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleList (int $page = 1, int $pageSize = 20, string $roleName = null) {
        return self::getClass()->getRoleList([
            "page" => $page,
            "pageSize" => $pageSize,
            "roleName" => $roleName,
        ]);
    }

    /**
     * 获取岗位列表
     *
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @param  string $positionName 岗位名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionList (int $page = 1, int $pageSize = 50, string $positionName = null) {
        return self::getClass()->getPositionList([
            "page" => $page,
            "pageSize" => $pageSize,
            "positionName" => $positionName,
        ]);
    }

    /**
     * 绑定角色岗位关系(全量)
     *
     * @param  int $roleId 角色id [ require true ]
     * @param  array $positionIds 岗位ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindRolePosition (int $roleId, array $positionIds) {
        return self::getClass()->bindRolePosition([
            "roleId" => $roleId,
            "positionIds" => $positionIds,
        ]);
    }

    /**
     * 解绑角色岗位关系
     *
     * @param  array $roleIds 角色id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unbindRolePosition (array $roleIds) {
        return self::getClass()->unbindRolePosition([
            "roleIds" => $roleIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\Ovopark');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\Ovopark');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}