<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeisenStaffByParams(array $params)
 * @method syncStaffEventByParams(array $params)
 * @method batchCreateNasStaffByParams(array $params)
 * @method batchLeaveByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCreateOvoparkStaffByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步指定北森员工
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeisenStaff (int $staffId) {
        return self::getClass()->syncBeisenStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 同步指定员工事件到指定服务或第三方
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $action 操作。新增：create;更新：update;删除：delete；重新入职：restore [ require true ]
     * @param  array $services 指定服务或第三方 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function syncStaffEvent (int $staffId, string $action = 'create', array $services = []) {
        return self::getClass()->syncStaffEvent([
            "staffId" => $staffId,
            "action" => $action,
            "services" => $services,
        ]);
    }

    /**
     * 批量创建NAS账号
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreateNasStaff (array $staffIds) {
        return self::getClass()->batchCreateNasStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量离职
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchLeave (array $staffIds) {
        return self::getClass()->batchLeave([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量入职
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreate (array $staffIds) {
        return self::getClass()->batchCreate([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  array $staffIds 工号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate (array $staffIds) {
        return self::getClass()->batchUpdate([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 添加万店掌用户表
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  int $userId 万店掌用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreateOvoparkStaff (int $staffId, int $userId) {
        return self::getClass()->batchCreateOvoparkStaff([
            "staffId" => $staffId,
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}