<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncTableByParams(array $params)
 * @method syncStorageTableByParams(array $params)
 * @method syncMaterialTableByParams(array $params)
 */
class Kingdee {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步中间表
     *
     * @param  string $table 表名 [ require true ]
     * @param  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncTable (string $table, array $params) {
        return self::getClass()->syncTable([
            "table" => $table,
            "params" => $params,
        ]);
    }

    /**
     * 同步仓库表
     *
     * @support  int $id 仓库编码 [ require true ]
     * @support  string $name 仓库名称 [ require true ]
     * @support  int $type 类型。1是门店 2非门店 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStorageTable () {
        return self::getClass()->syncStorageTable();
    }

    /**
     * 同步物料表
     *
     * @support  string $sku_code 物料编码 [ require true ]
     * @support  string $sku_name 物料名称 [ require true ]
     * @support  int $source 物料分类。1 自用，2 零售， 3 原材料 [ require true ]
     * @support  string $category_id 物料分组编码.根据 category_id 获取 对应三级分类组合成 xx.xx.xx [ require true ]
     * @support  int $unit_id 计量单位编码id [ require true ]
     * @support  string $cost_price 成本价 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncMaterialTable () {
        return self::getClass()->syncMaterialTable();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\Kingdee');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\Kingdee');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}