<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createJdOrderByParams(array $params)
 * @method updateJdOrderByParams(array $params)
 * @method getConfigItemByParams(array $params)
 */
class JdYunDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 京东订单创建通知
     *
     * @support  mixed $object 消息体 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createJdOrder () {
        return self::getClass()->createJdOrder();
    }

    /**
     * 京东订单变更通知
     *
     * @support  mixed $object 消息体 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateJdOrder () {
        return self::getClass()->updateJdOrder();
    }

    /**
     * test
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getConfigItem () {
        return self::getClass()->getConfigItem();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'ThirdParty\JdYunDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'ThirdParty\JdYunDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}