<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncJdPauseOrderByParams(array $params)
 * @method syncJdRefundOrderByParams(array $params)
 */
class JdYunDingCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步京东 pause 状态订单数据-每隔6分钟执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncJdPauseOrder () {
        return self::getClass()->syncJdPauseOrder();
    }

    /**
     * 同步京东退款状态订单数据-每隔5分钟执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncJdRefundOrder () {
        return self::getClass()->syncJdRefundOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Cron\JdYunDingCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Cron\JdYunDingCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}