<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\ThirdParty;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createJdOrderByParams(array $params)
 * @method updateJdOrderByParams(array $params)
 */
class JdYunDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 京东订单创建通知
     *
     * @support  string $orderId 订单号 [ require true ]
     * @support  int $orderType 订单类型 [ require true ]
     * @support  string $orderStatus 订单状态 [ require true ]
     * @support  string $orderCreateTime 订单创建时间 [ require true ]
     * @support  int $orderPaymentType 订单支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createJdOrder () {
        return self::getClass()->createJdOrder();
    }

    /**
     * 京东订单变更通知
     *
     * @support  string $orderId 订单号 [ require true ]
     * @support  int $orderType 订单类型 [ require true ]
     * @support  string $orderCreateTime 订单创建时间 [ require true ]
     * @support  int $orderPaymentType 订单支付方式 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateJdOrder () {
        return self::getClass()->updateJdOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'ThirdParty\JdYunDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'ThirdParty\JdYunDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}