<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeiSenByParams(array $params)
 * @method syncGaiaByParams(array $params)
 * @method syncNasByParams(array $params)
 * @method syncOvoParkByParams(array $params)
 * @method useCouponCodeByParams(array $params)
 */
class RpcMessageHandle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步北森信息
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeiSen () {
        return self::getClass()->syncBeiSen();
    }

    /**
     * 同步盖雅信息
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncGaia () {
        return self::getClass()->syncGaia();
    }

    /**
     * 同步Nas
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncNas () {
        return self::getClass()->syncNas();
    }

    /**
     * 同步万店掌
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncOvoPark () {
        return self::getClass()->syncOvoPark();
    }

    /**
     * 使用优惠券
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function useCouponCode () {
        return self::getClass()->useCouponCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\RpcMessageHandle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\RpcMessageHandle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}