<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncMaterialSkuByParams(array $params)
 * @method createPurchaseOrderByParams(array $params)
 * @method createPurchaseDueByParams(array $params)
 * @method createPurchaseAdvanceByParams(array $params)
 * @method createAllocationByParams(array $params)
 * @method createReceiveByParams(array $params)
 */
class NetSuite {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步物料信息
     *
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncMaterialSku () {
        return self::getClass()->syncMaterialSku();
    }

    /**
     * 创建采购订单
     *
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createPurchaseOrder () {
        return self::getClass()->createPurchaseOrder();
    }

    /**
     * 创建应付账单
     *
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createPurchaseDue () {
        return self::getClass()->createPurchaseDue();
    }

    /**
     * 创建预付款单
     *
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createPurchaseAdvance () {
        return self::getClass()->createPurchaseAdvance();
    }

    /**
     * 创建库存转移订单
     *
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createAllocation () {
        return self::getClass()->createAllocation();
    }

    /**
     * 创建入库单
     *
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createReceive () {
        return self::getClass()->createReceive();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\NetSuite');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\NetSuite');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}