<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeiSenByParams(array $params)
 * @method syncGaiaByParams(array $params)
 * @method syncNasByParams(array $params)
 * @method syncOvoParkByParams(array $params)
 * @method syncMaycurByParams(array $params)
 * @method supplyPaymentByParams(array $params)
 */
class RpcMessageHandle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步北森信息
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeiSen () {
        return self::getClass()->syncBeiSen();
    }

    /**
     * 同步盖雅信息
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncGaia () {
        return self::getClass()->syncGaia();
    }

    /**
     * 同步Nas
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncNas () {
        return self::getClass()->syncNas();
    }

    /**
     * 同步万店掌
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncOvoPark () {
        return self::getClass()->syncOvoPark();
    }

    /**
     * 同步每刻
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncMaycur () {
        return self::getClass()->syncMaycur();
    }

    /**
     * 生成采购支付单
     *
     * @support  int $fromId 付款流水号 [ require true ]
     * @support  string $reportDate 单据日期 require false
     * @support  string $latestPaymentDate 最晚付款时间 require false
     * @support  string $fromType 来源类型 require false
     * @support  string $fromCode 来源单据号 [ require true ]
     * @support  string $payName 付款组织 require false
     * @support  float $money 申请金额 [ require true ]
     * @support  string $payeeName 收款人 require false
     * @support  string $payeeAccount 收款账号 require false
     * @support  string $bankBranch 支行 require false
     * @support  string $bankNumber 联行号 require false
     * @support  string $reportType 付款类型 require false
     * @support  string $payType 付款方式 require false
     * @support  string $paymentPurpose 付款用途 require false
     * @support  string $proposer 申请人 [ require true ]
     * @support  string $departmentName 申请部门 [ require true ]
     * @support  string $bankName 总行 require false
     * @support  string $objectName 收款对象名称 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function supplyPayment () {
        return self::getClass()->supplyPayment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\RpcMessageHandle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\RpcMessageHandle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}