<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Tool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrUpdateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Kingdee {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增、更新金蝶数据
     *
     * @support  string $table 金蝶表名 [ require true ]
     * @support  array $params 参数 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createOrUpdate () {
        return self::getClass()->createOrUpdate();
    }

    /**
     * 删除金蝶数据
     *
     * @support  string $table 金蝶表名 [ require true ]
     * @support  array $ids id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Tool\Kingdee');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Tool\Kingdee');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}