<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrUpdateSupplierByParams(array $params)
 * @method getSupplierListByParams(array $params)
 * @method getSupplierDetailByParams(array $params)
 * @method exportSupplierByParams(array $params)
 * @method createOrUpdateBankByParams(array $params)
 * @method getBankListByParams(array $params)
 * @method getBankDetailByParams(array $params)
 * @method exportBankByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建/更新供应商
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $type 供应商类型.01:采买物料,02:广告服务,03:技术/中介服务,04:零星采购,05:装修装饰,06:租金水电 [ require true ]
     * @support  string $contact 联系人 require false
     * @support  string $phone 电话 require false
     * @support  string $address 地址 require false
     * @support  bool $status 状态 require false
     * @support  mixed $banks 银行 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrUpdateSupplier () {
        return self::getClass()->createOrUpdateSupplier();
    }

    /**
     * 获取供应商列表
     *
     * @support  string $name 名称 require false
     * @support  string $cardNumber 卡号 require false
     * @support  string $type 供应商类型.01:采买物料,02:广告服务,03:技术/中介服务,04:零星采购,05:装修装饰,06:租金水电 require false
     * @support  bool $status 状态 require false
     * @support  string $pay_type 支付方式。bank:银行，ali:支付宝,wx:微信,web:网页 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplierList () {
        return self::getClass()->getSupplierList();
    }

    /**
     * 获取供应商信息
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplierDetail () {
        return self::getClass()->getSupplierDetail();
    }

    /**
     * 供应商导出
     *
     * @support  string $name 名称 require false
     * @support  string $cardNumber 卡号 require false
     * @support  string $type 供应商类型.01:采买物料,02:广告服务,03:技术/中介服务,04:零星采购,05:装修装饰,06:租金水电 require false
     * @support  bool $status 状态 require false
     * @support  string $pay_type 支付方式。bank:银行，ali:支付宝,wx:微信,web:网页 require false
     * @throws  \Exception
     * @return  array
     */
    public static function exportSupplier () {
        return self::getClass()->exportSupplier();
    }

    /**
     * 创建/更新银行
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $card_number 联行号 [ require true ]
     * @support  string $type 银行分类。head:总行，branch:支行 [ require true ]
     * @support  string $parent_bank 上级银行 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrUpdateBank () {
        return self::getClass()->createOrUpdateBank();
    }

    /**
     * 获取银行列表
     *
     * @support  string $name 名称 require false
     * @support  string $type 银行分类。head:总行，branch:支行 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getBankList () {
        return self::getClass()->getBankList();
    }

    /**
     * 获取银行详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBankDetail () {
        return self::getClass()->getBankDetail();
    }

    /**
     * 银行导出
     *
     * @support  string $name 名称 require false
     * @support  string $type 银行分类。head:总行，branch:支行 require false
     * @throws  \Exception
     * @return  array
     */
    public static function exportBank () {
        return self::getClass()->exportBank();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}