<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Inside;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncAttendanceByParams(array $params)
 * @method syncStaffByParams(array $params)
 * @method syncDepartmentByParams(array $params)
 */
class Gaia {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步考勤数据
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncAttendance () {
        return self::getClass()->syncAttendance();
    }

    /**
     * 同步给盖雅员工信息
     *
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @param  bool $all 同步全量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStaff (string $start = '', string $end = '', bool $all = false) {
        return self::getClass()->syncStaff([
            "start" => $start,
            "end" => $end,
            "all" => $all,
        ]);
    }

    /**
     * 同步给盖雅组织信息
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncDepartment () {
        return self::getClass()->syncDepartment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Inside\Gaia');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Inside\Gaia');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}