<?php
namespace Mainto\Bridge\Invokes\HimoEbsV2\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncBeisenByParams(array $params)
 * @method syncJobLevelByParams(array $params)
 * @method syncDepartmentByParams(array $params)
 * @method syncStaffByParams(array $params)
 * @method syncMultiStoreManageByParams(array $params)
 * @method syncPositionByParams(array $params)
 */
class Beisen {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步北森数据
     *
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncBeisen (string $start = '', string $end = '') {
        return self::getClass()->syncBeisen([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 同步北森职级
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function syncJobLevel () {
        return self::getClass()->syncJobLevel();
    }

    /**
     * 同步北森部门
     *
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncDepartment (string $start = '', string $end = '') {
        return self::getClass()->syncDepartment([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 同步北森员工
     *
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncStaff (string $start = '', string $end = '') {
        return self::getClass()->syncStaff([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 同步北森多店管理
     *
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncMultiStoreManage (string $start = '', string $end = '') {
        return self::getClass()->syncMultiStoreManage([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * 同步北森职务
     *
     * @param  string $start 开始时间 [ require true ]
     * @param  string $end 结束时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncPosition (string $start = '', string $end = '') {
        return self::getClass()->syncPosition([
            "start" => $start,
            "end" => $end,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoEbsV2', 'Cron\Beisen');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoEbsV2', 'Cron\Beisen');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}