<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-18 14:26:06
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method listenOrderDeletedByParams(array $params) 监听订单删除事件
 * @method listenOrderRetakeSaleSkuByParams(array $params) 监听订单重拍事件
 * @method listenOrderPartRefundByParams(array $params) 监听订单部分退款事件
 * @method listenOrderRefundByParams(array $params) 监听订单退款事件
 */
class Order {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "MessageQueue\\Order";

    /**
     * 监听订单删除事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenOrderDeleted (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderDeleted(["orderId" => $orderId]);
    }

    /**
     * 监听订单重拍事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenOrderRetakeSaleSku (int $orderId, array $retakeOrderSakeSku) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderRetakeSaleSku(["orderId" => $orderId, "retakeOrderSakeSku" => $retakeOrderSakeSku]);
    }

    /**
     * 监听订单部分退款事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenOrderPartRefund (string $refundType, array $skuList, array $refundSkuList, string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderPartRefund(["refundType" => $refundType, "skuList" => $skuList, "refundSkuList" => $refundSkuList, "orderNo" => $orderNo]);
    }

    /**
     * 监听订单退款事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function listenOrderRefund (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderRefund(["orderId" => $orderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}