<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-06-18 14:26:06
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ContentCommunity
 * @method userNewTipsByParams(array $params) 获取首页(新内容提示和待发布文案)
 * @method contentPublishConfigByParams(array $params) 获取场景标签和文案提示
 * @method contentSearchByParams(array $params) 内容搜索
 * @method officialContentListByParams(array $params) 获取官方发布内容列表
 * @method contentListByParams(array $params) 获取内容列表
 * @method contentDetailByParams(array $params) 获取内容详情
 * @method contentLikeByParams(array $params) 内容点赞
 * @method contentLikeCancelByParams(array $params) 内容取消点赞
 * @method contentTipCloseByParams(array $params) 用户当日关闭横幅
 * @method unreleasedOrderExistsByParams(array $params) 是否存在待发布订单
 * @method contentDeleteByParams(array $params) 删除内容
 * @method contentShareByParams(array $params) 内容分享
 * @method contentViewByParams(array $params) 内容浏览
 * @method contentAddByParams(array $params) 发布内容
 * @method contentUpdateByParams(array $params) 编辑内容
 * @method isShowAuthorizationLayerByParams(array $params) 是否显示发布授权弹窗
 * @method agreeContentAuthorizationByParams(array $params) 同意圈圈授权
 * @method photoAlbumListByParams(array $params) 客片相册列表
 * @method photoAlbumDetailByParams(array $params) 客片相册详情
 * @method clearContentNewMessageByParams(array $params) 清除新消息(红点)
 * @method myContentListByParams(array $params) 我的圈圈列表
 * @method userLikeContentListByParams(array $params) 我点赞的圈圈列表
 * @method contentUserInfoByParams(array $params) 圈圈-我的页面用户信息
 * @method contentEnvConfigByParams(array $params) 圈圈-获取环境配置和横幅标题
 * @method paginateBuyerShowContentByParams(array $params) 客片秀列表分页查询
 * @method getBuyerShowContentSkuByParams(array $params) 客片秀sku信息
 * @method userNewTipsV1ByParams(array $params) 获取首页(新内容提示和待发布文案).v1
 * @method contentPublishConfigV1ByParams(array $params) 获取场景标签和文案提示.v1
 * @method contentSearchV1ByParams(array $params) 内容搜索.v1
 * @method officialContentListV1ByParams(array $params) 获取官方发布内容列表 v1
 * @method contentListV1ByParams(array $params) 获取内容列表.v1
 * @method contentDetailV1ByParams(array $params) 获取内容详情.v1
 * @method contentLikeV1ByParams(array $params) 内容点赞.v1
 * @method contentLikeCancelV1ByParams(array $params) 内容取消点赞.v1
 * @method contentTipCloseV1ByParams(array $params) 用户当日关闭横幅.v1
 * @method unreleasedOrderExistsV1ByParams(array $params) 是否存在待发布订单.v1
 * @method contentDeleteV1ByParams(array $params) 删除内容.v1
 * @method contentShareV1ByParams(array $params) 内容分享.v1
 * @method contentViewV1ByParams(array $params) 内容浏览.v1
 * @method contentAddV1ByParams(array $params) 发布内容.v1
 * @method contentUpdateV1ByParams(array $params) 编辑内容.v1
 * @method isShowAuthorizationLayerV1ByParams(array $params) 是否显示发布授权弹窗.v1
 * @method agreeContentAuthorizationV1ByParams(array $params) 同意圈圈授权.v1
 * @method photoAlbumListV1ByParams(array $params) 客片相册列表.v1
 * @method photoAlbumDetailV1ByParams(array $params) 客片相册详情v1
 * @method clearContentNewMessageV1ByParams(array $params) 清除新消息(红点).v1
 * @method myContentListV1ByParams(array $params) 我的圈圈列表.v1
 * @method userLikeContentListV1ByParams(array $params) 我点赞的圈圈列表.v1
 * @method contentUserInfoV1ByParams(array $params) 圈圈-我的页面用户信息.v1
 * @method contentEnvConfigV1ByParams(array $params) 圈圈-获取环境配置和横幅标题.v1
 */
class ContentCommunity {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "Content\\ContentCommunity";

    /**
     * 获取首页(新内容提示和待发布文案)
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO
    */
    public static function userNewTips () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userNewTips(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO"
        );
    }

    /**
     * 获取场景标签和文案提示
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO
    */
    public static function contentPublishConfig (string $originPage = 'content_publish') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentPublishConfig(["originPage" => $originPage]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO"
        );
    }

    /**
     * 内容搜索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function contentSearch (string $searchName, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentSearch(["searchName" => $searchName, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取官方发布内容列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function officialContentList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->officialContentList([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]"
        );
    }

    /**
     * 获取内容列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function contentList (int $page = 1) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentList(["page" => $page]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取内容详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO
    */
    public static function contentDetail (int $contentId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentDetail(["contentId" => $contentId]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }

    /**
     * 内容点赞
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentLike (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLike(["contentId" => $contentId]);
    }

    /**
     * 内容取消点赞
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentLikeCancel (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLikeCancel(["contentId" => $contentId]);
    }

    /**
     * 用户当日关闭横幅
     * @return  bool
    */
    public static function contentTipClose () {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentTipClose();
    }

    /**
     * 是否存在待发布订单
     * @return  bool
    */
    public static function unreleasedOrderExists () {
        return RpcClass::getClass(self::$serviceName, self::$className)->unreleasedOrderExists();
    }

    /**
     * 删除内容
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentDelete (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentDelete(["contentId" => $contentId]);
    }

    /**
     * 内容分享
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentShare (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentShare(["contentId" => $contentId]);
    }

    /**
     * 内容浏览
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentView (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentView(["contentId" => $contentId]);
    }

    /**
     * 发布内容
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO
    */
    public static function contentAdd (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentAdd($contentAddCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO"
        );
    }

    /**
     * 编辑内容
     * @return  bool
    */
    public static function contentUpdate (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentUpdate($contentUpdateCMD);
    }

    /**
     * 是否显示发布授权弹窗
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO
    */
    public static function isShowAuthorizationLayer () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->isShowAuthorizationLayer(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO"
        );
    }

    /**
     * 同意圈圈授权
     * @return  bool
    */
    public static function agreeContentAuthorization () {
        return RpcClass::getClass(self::$serviceName, self::$className)->agreeContentAuthorization();
    }

    /**
     * 客片相册列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO
    */
    public static function photoAlbumList (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumList(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO"
        );
    }

    /**
     * 客片相册详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO
    */
    public static function photoAlbumDetail (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumDetail(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO"
        );
    }

    /**
     * 清除新消息(红点)
     * @return  bool
    */
    public static function clearContentNewMessage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearContentNewMessage();
    }

    /**
     * 我的圈圈列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function myContentList (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->myContentList(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 我点赞的圈圈列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function userLikeContentList (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userLikeContentList(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 圈圈-我的页面用户信息
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO
    */
    public static function contentUserInfo () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentUserInfo(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO"
        );
    }

    /**
     * 圈圈-获取环境配置和横幅标题
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO
    */
    public static function contentEnvConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentEnvConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO"
        );
    }

    /**
     * 客片秀列表分页查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PaginateBuyerShowContentDTO
    */
    public static function paginateBuyerShowContent (int $page = 1, int $pageSize = 6) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paginateBuyerShowContent(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PaginateBuyerShowContentDTO"
        );
    }

    /**
     * 客片秀sku信息
     * @return  array
    */
    public static function getBuyerShowContentSku (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\BuyerShowContentSkuCMD $buyerShowContentSkuCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBuyerShowContentSku($buyerShowContentSkuCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\BuyerShowContentSkuDTO[]"
        );
    }

    /**
     * 获取首页(新内容提示和待发布文案).v1
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO
    */
    public static function userNewTipsV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userNewTipsV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO"
        );
    }

    /**
     * 获取场景标签和文案提示.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO
    */
    public static function contentPublishConfigV1 (string $originPage = 'content_publish') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentPublishConfigV1(["originPage" => $originPage]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO"
        );
    }

    /**
     * 内容搜索.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function contentSearchV1 (string $searchName, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentSearchV1(["searchName" => $searchName, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取官方发布内容列表 v1
     * @return  array
    */
    public static function officialContentListV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->officialContentListV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]"
        );
    }

    /**
     * 获取内容列表.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function contentListV1 (int $page = 1) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentListV1(["page" => $page]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取内容详情.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO
    */
    public static function contentDetailV1 (int $contentId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentDetailV1(["contentId" => $contentId]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }

    /**
     * 内容点赞.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentLikeV1 (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLikeV1(["contentId" => $contentId]);
    }

    /**
     * 内容取消点赞.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentLikeCancelV1 (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLikeCancelV1(["contentId" => $contentId]);
    }

    /**
     * 用户当日关闭横幅.v1
     * @return  bool
    */
    public static function contentTipCloseV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentTipCloseV1();
    }

    /**
     * 是否存在待发布订单.v1
     * @return  bool
    */
    public static function unreleasedOrderExistsV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->unreleasedOrderExistsV1();
    }

    /**
     * 删除内容.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentDeleteV1 (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentDeleteV1(["contentId" => $contentId]);
    }

    /**
     * 内容分享.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentShareV1 (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentShareV1(["contentId" => $contentId]);
    }

    /**
     * 内容浏览.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function contentViewV1 (int $contentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentViewV1(["contentId" => $contentId]);
    }

    /**
     * 发布内容.v1
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO
    */
    public static function contentAddV1 (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentAddV1($contentAddCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO"
        );
    }

    /**
     * 编辑内容.v1
     * @return  bool
    */
    public static function contentUpdateV1 (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentUpdateV1($contentUpdateCMD);
    }

    /**
     * 是否显示发布授权弹窗.v1
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO
    */
    public static function isShowAuthorizationLayerV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->isShowAuthorizationLayerV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO"
        );
    }

    /**
     * 同意圈圈授权.v1
     * @return  bool
    */
    public static function agreeContentAuthorizationV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->agreeContentAuthorizationV1();
    }

    /**
     * 客片相册列表.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO
    */
    public static function photoAlbumListV1 (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumListV1(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO"
        );
    }

    /**
     * 客片相册详情v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO
    */
    public static function photoAlbumDetailV1 (string $orderNum) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumDetailV1(["orderNum" => $orderNum]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO"
        );
    }

    /**
     * 清除新消息(红点).v1
     * @return  bool
    */
    public static function clearContentNewMessageV1 () {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearContentNewMessageV1();
    }

    /**
     * 我的圈圈列表.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function myContentListV1 (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->myContentListV1(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 我点赞的圈圈列表.v1
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function userLikeContentListV1 (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userLikeContentListV1(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 圈圈-我的页面用户信息.v1
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO
    */
    public static function contentUserInfoV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentUserInfoV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO"
        );
    }

    /**
     * 圈圈-获取环境配置和横幅标题.v1
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO
    */
    public static function contentEnvConfigV1 () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentEnvConfigV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}