<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-12-01 16:12:31
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ContentActivity
 * @method contentListByParams(array $params) 活动标签内容列表
 * @method unreleasedActivityOrderExistsByParams(array $params) 待发布的活动订单是否存在
 * @method contentActivityConfigByParams(array $params) 童话季活动配置
 * @method newYearActivityConfigByParams(array $params) 新年活动配置
 * @method princessSeasonConfigByParams(array $params) 公主季活动配置
 * @method confessionSeasonConfigByParams(array $params) 告白季活动配置
 * @method graduationSeasonConfigByParams(array $params) 毕业季活动配置
 * @method chineseStyleSeasonConfigByParams(array $params) 国风季活动配置
 * @method bestieSeasonConfigByParams(array $params) 闺蜜季活动配置
 * @method schoolSeasonConfigByParams(array $params) 开学季活动配置
 * @method commonActivityConfigByParams(array $params) 圈圈活动配置
 * @method activityContentListByParams(array $params) 活动标签内容列表(新版)）
 */
class ContentActivity {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "Content\\ContentActivity";

    /**
     * 活动标签内容列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function contentList (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentList(["page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 待发布的活动订单是否存在
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function unreleasedActivityOrderExists (string $activityName = 'fairyTales') {
        return RpcClass::getClass(self::$serviceName, self::$className)->unreleasedActivityOrderExists(["activityName" => $activityName]);
    }

    /**
     * 童话季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ContentActivityConfigDTO
    */
    public static function contentActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentActivityConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ContentActivityConfigDTO"
        );
    }

    /**
     * 新年活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\NewYearActivityConfigDTO
    */
    public static function newYearActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->newYearActivityConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\NewYearActivityConfigDTO"
        );
    }

    /**
     * 公主季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\PrincessSeason\PrincessSeasonActivityConfigDTO
    */
    public static function princessSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->princessSeasonConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\PrincessSeason\PrincessSeasonActivityConfigDTO"
        );
    }

    /**
     * 告白季活动配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ConfessionSeason\ConfessionSeasonActivityConfigDTO
    */
    public static function confessionSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->confessionSeasonConfig([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ConfessionSeason\ConfessionSeasonActivityConfigDTO"
        );
    }

    /**
     * 毕业季活动配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\GraduationSeason\GraduationSeasonConfigDTO
    */
    public static function graduationSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->graduationSeasonConfig([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\GraduationSeason\GraduationSeasonConfigDTO"
        );
    }

    /**
     * 国风季活动配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ChineseStyleSeason\ChineseStyleSeasonConfigDTO
    */
    public static function chineseStyleSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->chineseStyleSeasonConfig([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ChineseStyleSeason\ChineseStyleSeasonConfigDTO"
        );
    }

    /**
     * 闺蜜季活动配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\BestieSeason\BestieSeasonConfigDTO
    */
    public static function bestieSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bestieSeasonConfig([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\BestieSeason\BestieSeasonConfigDTO"
        );
    }

    /**
     * 开学季活动配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\SchoolSeason\SchoolSeasonConfigDTO
    */
    public static function schoolSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->schoolSeasonConfig([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\SchoolSeason\SchoolSeasonConfigDTO"
        );
    }

    /**
     * 圈圈活动配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\Common\CommonActivityConfigDTO
    */
    public static function commonActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->commonActivityConfig([]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\Common\CommonActivityConfigDTO"
        );
    }

    /**
     * 活动标签内容列表(新版)）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function activityContentList (string $sortType = 'recommend', int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->activityContentList(["sortType" => $sortType, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}