<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-03 16:32:02
 */
namespace Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin;

class ContentAdminAddCMD {
    /**
     * @var  null|string
     * 用户姓名
     * validation: required_if:promoterType,staff_add_virtual_order|max:20
     */
    public ?string $userName;
    /**
     * @var  null|string
     * 用户头像(全路径)
     * validation: required_if:promoterType,staff_add_virtual_order
     */
    public ?string $headSculpture;
    /**
     * @var  string
     * 用户性别
     * validation: required|in:male,female
     */
    public string $userSex;
    /**
     * @var  null|string
     * 用户等级
     * validation: sometimes|in:v1,v2,v3,v4
     */
    public ?string $userLevel = null;
    /**
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddPhotoCMD[]
     * 相册数据
     * validation: required|max:9
     */
    public array $photos;
    /**
     * @var  null|string
     * 标题
     * validation: sometimes|max:20
     */
    public ?string $commentTitle = null;
    /**
     * @var  string
     * 内容
     * validation: required|max:2000
     */
    public string $comment;
    /**
     * @var  int[]
     * 标签ids
     * validation: 
     */
    public array $tagIds;
    /**
     * @var  string
     * 发起类型
     * validation: required|in:official,staff_add_virtual_order
     */
    public string $promoterType;
    /**
     * @var  null|int
     * 排序值
     * validation: required_if:promoterType,official
     */
    public ?int $sort = null;
    /**
     * @var  null|string
     * 订单号
     * validation: 
     */
    public ?string $orderNum = null;
    /**
     * @var  string
     * 品牌
     * validation: 
     */
    public string $brand = "himo";
    /**
     * @var  string
     * 手机号
     * validation: 
     */
    public string $userPhone = "10000000000";

    public function __construct (?string $userName = '', ?string $headSculpture = '', string $userSex = '', array $photos = [], string $comment = '', array $tagIds = [], string $promoterType = '', int $promoterId = 0) {
        if (!is_null($userName)) {
            $this->userName = $userName;
        }
        if (!is_null($headSculpture)) {
            $this->headSculpture = $headSculpture;
        }
        if (!is_null($userSex)) {
            $this->userSex = $userSex;
        }
        if (!is_null($photos)) {
            $this->photos = $photos;
        }
        if (!is_null($comment)) {
            $this->comment = $comment;
        }
        if (!is_null($tagIds)) {
            $this->tagIds = $tagIds;
        }
        if (!is_null($promoterType)) {
            $this->promoterType = $promoterType;
        }
        if (!is_null($promoterId)) {
            $this->promoterId = $promoterId;
        }
    }

    public static function create(?string $userName = '', ?string $headSculpture = '', string $userSex = '', array $photos = [], string $comment = '', array $tagIds = [], string $promoterType = '', int $promoterId = 0): self {
        return new self($userName, $headSculpture, $userSex, $photos, $comment, $tagIds, $promoterType, $promoterId);
    }

    public function setUserName(?string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setHeadSculpture(?string $headSculpture): self {
        $this->headSculpture = $headSculpture;

        return $this;
    }

    public function setUserSex(string $userSex): self {
        $this->userSex = $userSex;

        return $this;
    }

    public function setUserLevel(?string $userLevel): self {
        $this->userLevel = $userLevel;

        return $this;
    }

    public function setPhotos(array $photos): self {
        $this->photos = $photos;

        return $this;
    }

    public function setCommentTitle(?string $commentTitle): self {
        $this->commentTitle = $commentTitle;

        return $this;
    }

    public function setComment(string $comment): self {
        $this->comment = $comment;

        return $this;
    }

    public function setTagIds(array $tagIds): self {
        $this->tagIds = $tagIds;

        return $this;
    }

    public function setPromoterType(string $promoterType): self {
        $this->promoterType = $promoterType;

        return $this;
    }

    public function setSort(?int $sort): self {
        $this->sort = $sort;

        return $this;
    }

    public function setOrderNum(?string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setBrand(string $brand): self {
        $this->brand = $brand;

        return $this;
    }

    public function setUserPhone(string $userPhone): self {
        $this->userPhone = $userPhone;

        return $this;
    }
}