<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-25 15:17:05
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ContentActivity
 */
class ContentActivity {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "Content\\ContentActivity";

    /**
     * 活动标签内容列表
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
    */
    public static function contentList (string $sortType, int $tagId, int $page = 1, int $pageSize = 10, string $productIdsStr) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentList(["sortType" => $sortType, "tagId" => $tagId, "page" => $page, "pageSize" => $pageSize, "productIdsStr" => $productIdsStr]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 待发布的活动订单是否存在
     * @return  bool
    */
    public static function unreleasedActivityOrderExists (string $activityName = 'fairyTales') {
        return RpcClass::getClass(self::$serviceName, self::$className)->unreleasedActivityOrderExists(["activityName" => $activityName]);
    }
    /**
     * 童话季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ContentActivityConfigDTO
    */
    public static function contentActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentActivityConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ContentActivityConfigDTO"
        );
    }
    /**
     * 新年活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\NewYearActivityConfigDTO
    */
    public static function newYearActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->newYearActivityConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\NewYearActivityConfigDTO"
        );
    }
    /**
     * 公主季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\PrincessSeason\PrincessSeasonActivityConfigDTO
    */
    public static function princessSeasonConfig () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->princessSeasonConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\PrincessSeason\PrincessSeasonActivityConfigDTO"
        );
    }
    /**
     * 告白季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ConfessionSeason\ConfessionSeasonActivityConfigDTO
    */
    public static function confessionSeasonConfig (string $originAppKey) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->confessionSeasonConfig(["originAppKey" => $originAppKey]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ConfessionSeason\ConfessionSeasonActivityConfigDTO"
        );
    }
    /**
     * 毕业季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\GraduationSeason\GraduationSeasonConfigDTO
    */
    public static function graduationSeasonConfig (string $originAppKey) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->graduationSeasonConfig(["originAppKey" => $originAppKey]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\GraduationSeason\GraduationSeasonConfigDTO"
        );
    }
    /**
     * 国风季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ChineseStyleSeason\ChineseStyleSeasonConfigDTO
    */
    public static function chineseStyleSeasonConfig (string $originAppKey) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->chineseStyleSeasonConfig(["originAppKey" => $originAppKey]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ChineseStyleSeason\ChineseStyleSeasonConfigDTO"
        );
    }
    /**
     * 闺蜜季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\BestieSeason\BestieSeasonConfigDTO
    */
    public static function bestieSeasonConfig (string $originAppKey) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bestieSeasonConfig(["originAppKey" => $originAppKey]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\BestieSeason\BestieSeasonConfigDTO"
        );
    }
    /**
     * 开学季活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\SchoolSeason\SchoolSeasonConfigDTO
    */
    public static function schoolSeasonConfig (string $originAppKey) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->schoolSeasonConfig(["originAppKey" => $originAppKey]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\SchoolSeason\SchoolSeasonConfigDTO"
        );
    }
    /**
     * 圈圈活动配置
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\Common\CommonActivityConfigDTO
    */
    public static function commonActivityConfig (string $activityName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->commonActivityConfig(["activityName" => $activityName]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\Common\CommonActivityConfigDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}