<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-16 13:50:26
 */
namespace Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin;

class ContentAdminUpdateCMD {
    /**
     * @var  int
     * 内容id
     * validation: 
     */
    public int $contentId;
    /**
     * @var  null|string
     * 用户姓名
     * validation: required_if:promoterType,staff_add_virtual_order|max:20
     */
    public ?string $userName;
    /**
     * @var  null|string
     * 用户头像(全路径)
     * validation: required_if:promoterType,staff_add_virtual_order
     */
    public ?string $headSculpture;
    /**
     * @var  string
     * 用户性别
     * validation: required|in:male,female
     */
    public string $userSex;
    /**
     * @var  null|string
     * 用户等级
     * validation: sometimes|in:v1,v2,v3,v4
     */
    public ?string $userLevel = null;
    /**
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddPhotoCMD[]
     * 相册数据
     * validation: required|max:9
     */
    public array $photos;
    /**
     * @var  null|string
     * 标题
     * validation: sometimes|max:20
     */
    public ?string $commentTitle = null;
    /**
     * @var  string
     * 内容
     * validation: required|max:2000
     */
    public string $comment;
    /**
     * @var  int[]
     * 话题标签ids
     * validation: 
     */
    public array $tagIds;
    /**
     * @var  string
     * 发起类型
     * validation: required|in:official,staff_add_virtual_order
     */
    public string $promoterType;
    /**
     * @var  null|int
     * 排序值
     * validation: required_if:promoterType,official
     */
    public ?int $sort = null;

    public function __construct (int $contentId = 0, ?string $userName = '', ?string $headSculpture = '', string $userSex = '', array $photos = [], string $comment = '', array $tagIds = [], string $promoterType = '', int $promoterId = 0) {
        $this->contentId = $contentId;
        $this->userName = $userName;
        $this->headSculpture = $headSculpture;
        $this->userSex = $userSex;
        $this->photos = $photos;
        $this->comment = $comment;
        $this->tagIds = $tagIds;
        $this->promoterType = $promoterType;
        $this->promoterId = $promoterId;
    }

    public static function create(int $contentId = 0, ?string $userName = '', ?string $headSculpture = '', string $userSex = '', array $photos = [], string $comment = '', array $tagIds = [], string $promoterType = '', int $promoterId = 0): self {
        return new self($contentId, $userName, $headSculpture, $userSex, $photos, $comment, $tagIds, $promoterType, $promoterId);
    }

    public function setContentId(int $contentId): self {
        $this->contentId = $contentId;

        return $this;
    }

    public function setUserName(?string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setHeadSculpture(?string $headSculpture): self {
        $this->headSculpture = $headSculpture;

        return $this;
    }

    public function setUserSex(string $userSex): self {
        $this->userSex = $userSex;

        return $this;
    }

    public function setUserLevel(?string $userLevel): self {
        $this->userLevel = $userLevel;

        return $this;
    }

    public function setPhotos(array $photos): self {
        $this->photos = $photos;

        return $this;
    }

    public function setCommentTitle(?string $commentTitle): self {
        $this->commentTitle = $commentTitle;

        return $this;
    }

    public function setComment(string $comment): self {
        $this->comment = $comment;

        return $this;
    }

    public function setTagIds(array $tagIds): self {
        $this->tagIds = $tagIds;

        return $this;
    }

    public function setPromoterType(string $promoterType): self {
        $this->promoterType = $promoterType;

        return $this;
    }

    public function setSort(?int $sort): self {
        $this->sort = $sort;

        return $this;
    }
}