<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-20 11:09:32
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "MessageQueue\\Order";

    /**
     * 监听订单删除事件
     */
    public static function listenOrderDeleted (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderDeleted(["orderId" => $orderId, ]);
    }
    /**
     * 监听订单重拍事件
     */
    public static function listenOrderRetakeSaleSku (int $orderId, array $retakeOrderSakeSku): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderRetakeSaleSku(["orderId" => $orderId, "retakeOrderSakeSku" => $retakeOrderSakeSku, ]);
    }
    /**
     * 监听订单部分退款事件
     */
    public static function listenOrderPartRefund (string $refundType, array $skuList, array $refundSkuList, string $orderNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderPartRefund(["refundType" => $refundType, "skuList" => $skuList, "refundSkuList" => $refundSkuList, "orderNo" => $orderNo, ]);
    }
    /**
     * 监听订单退款事件
     */
    public static function listenOrderRefund (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenOrderRefund(["orderId" => $orderId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}