<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 16:47:50
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ContentSearch
 */
class ContentSearch {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "Content\\ContentSearch";

    /**
     * 获取搜索词列表和热门搜索词列表配置
     */
    public static function contentSearchConfig (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentSearchConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO"
        );
    }
    /**
     * 批量删除搜索词
     */
    public static function contentSearchTermsDelete (array $searchWordIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentSearchTermsDelete(["searchWordIds" => $searchWordIds, ]);
    }
    /**
     * 添加搜索词
     */
    public static function contentSearchWordCreate (string $searchWord, string $brand): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentSearchWordCreate(["searchWord" => $searchWord, "brand" => $brand, ]);
    }
    /**
     * 获取搜索词列表和热门搜索词列表配置.v1
     */
    public static function contentSearchConfigV1 (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentSearchConfigV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO"
        );
    }
    /**
     * 批量删除搜索词 v1
     */
    public static function contentSearchTermsDeleteV1 (array $searchWordIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentSearchTermsDeleteV1(["searchWordIds" => $searchWordIds, ]);
    }
    /**
     * 添加搜索词 v1
     */
    public static function contentSearchWordCreateV1 (string $searchWord, string $brand): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentSearchWordCreateV1(["searchWord" => $searchWord, "brand" => $brand, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}