<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 16:25:44
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Content
 */
class Content {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "MessageQueue\\Content";

    /**
     * 监听内容审核失败
     */
    public static function listenContentAuditFailed (int $shareOrderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenContentAuditFailed(["shareOrderId" => $shareOrderId, ]);
    }
    /**
     * 监听内容被精选
     */
    public static function listenContentSetStar (int $shareOrderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenContentSetStar(["shareOrderId" => $shareOrderId, ]);
    }
    /**
     * 监听内容精选取消事件
     */
    public static function listenContentCancelStar (int $shareOrderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenContentCancelStar(["shareOrderId" => $shareOrderId, ]);
    }
    /**
     * 监听内容上架或审核通过
     */
    public static function listenContentWaitStar (int $shareOrderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenContentWaitStar(["shareOrderId" => $shareOrderId, ]);
    }
    /**
     * 监听内容浏览技术存储事件
     */
    public static function contentReviewCountStore (array $contentIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentReviewCountStore(["contentIds" => $contentIds, ]);
    }
    /**
     * 内容状态变更
     */
    public static function listenContentStatusChange (int $shareOrderId, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenContentStatusChange(["shareOrderId" => $shareOrderId, "status" => $status, ]);
    }
    /**
     * 内容删除事件
     */
    public static function listenContentDelete (int $shareOrderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenContentDelete(["shareOrderId" => $shareOrderId, ]);
    }
    /**
     * 监听内容添加tag缓存
     */
    public static function listenAddTagContentIdsCache (int $tagId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenAddTagContentIdsCache(["tagId" => $tagId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}