<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 16:25:44
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ContentAdmin
 */
class ContentAdmin {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "Content\\ContentAdmin";

    /**
     * 获取内容列表
     */
    public static function contentList (?\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentListAdminCMD $contentListAdminCMD = null): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentList($contentListAdminCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 获取内容详情
     */
    public static function contentDetail (int $contentId): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentDetail(["contentId" => $contentId, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }
    /**
     * 获取场景标签
     */
    public static function contentTagList (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentTagList(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCommunityTagDTO[]"
        );
    }
    /**
     * 发布内容
     */
    public static function contentAdd (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminAddCMD $contentAdminAddCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentAdd($contentAdminAddCMD);
    }
    /**
     * 更新内容
     */
    public static function contentUpdate (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminUpdateCMD $contentAdminUpdateCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentUpdate($contentAdminUpdateCMD);
    }
    /**
     * 删除内容
     */
    public static function contentDelete (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentDelete(["contentId" => $contentId, ]);
    }
    /**
     * 买家秀列表
     */
    public static function contentCategoryList (?\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentCategoryListAdminCMD $contentCategoryListAdminCMD = null): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentCategoryList($contentCategoryListAdminCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryListDTO"
        );
    }
    /**
     * 买家秀详情
     */
    public static function contentCategoryDetail (int $contentId, int $categoryId): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentCategoryDetail(["contentId" => $contentId, "categoryId" => $categoryId, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryDetailDTO"
        );
    }
    /**
     * 设置买家秀照片精选
     */
    public static function contentCategoryPhotoSetStar (int $contentId, int $categoryId, array $starPhotos, int $staffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentCategoryPhotoSetStar(["contentId" => $contentId, "categoryId" => $categoryId, "starPhotos" => $starPhotos, "staffId" => $staffId, ]);
    }
    /**
     * 内容人工审核
     */
    public static function contentManualAudit (int $contentId, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentManualAudit(["contentId" => $contentId, "status" => $status, ]);
    }
    /**
     * 内容上架
     */
    public static function contentUp (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentUp(["contentId" => $contentId, ]);
    }
    /**
     * 内容下架
     */
    public static function contentDown (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentDown(["contentId" => $contentId, ]);
    }
    /**
     * 内容加权
     */
    public static function contentAddSortWeight (int $contentId, int $sortWeight, int $staffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentAddSortWeight(["contentId" => $contentId, "sortWeight" => $sortWeight, "staffId" => $staffId, ]);
    }
    /**
     * 内容取消加权
     */
    public static function contentCancelSortWeight (int $contentId, int $staffId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentCancelSortWeight(["contentId" => $contentId, "staffId" => $staffId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}