<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-24 11:20:44
 */
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ContentCommunity
 */
class ContentCommunity {
    private static string $serviceName = "HimoContentCommunity";

    private static string $className = "Content\\ContentCommunity";

    /**
     * 获取首页(新内容提示和待发布文案)
     */
    public static function userNewTips (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userNewTips(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO"
        );
    }
    /**
     * 获取场景标签和文案提示
     */
    public static function contentPublishConfig (string $originPage = 'content_publish'): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentPublishConfig(["originPage" => $originPage, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO"
        );
    }
    /**
     * 内容搜索
     */
    public static function contentSearch (string $searchName, string $sortType, int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentSearch(["searchName" => $searchName, "sortType" => $sortType, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 获取官方发布内容列表
     */
    public static function officialContentList (int $tagId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->officialContentList(["tagId" => $tagId, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]"
        );
    }
    /**
     * 获取内容列表
     */
    public static function contentList (int $tagId, int $page = 1): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentList(["tagId" => $tagId, "page" => $page, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 获取内容详情
     */
    public static function contentDetail (int $contentId): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentDetail(["contentId" => $contentId, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }
    /**
     * 内容点赞
     */
    public static function contentLike (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLike(["contentId" => $contentId, ]);
    }
    /**
     * 内容取消点赞
     */
    public static function contentLikeCancel (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLikeCancel(["contentId" => $contentId, ]);
    }
    /**
     * 用户当日关闭横幅
     */
    public static function contentTipClose (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentTipClose();
    }
    /**
     * 是否存在待发布订单
     */
    public static function unreleasedOrderExists (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->unreleasedOrderExists();
    }
    /**
     * 删除内容
     */
    public static function contentDelete (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentDelete(["contentId" => $contentId, ]);
    }
    /**
     * 内容分享
     */
    public static function contentShare (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentShare(["contentId" => $contentId, ]);
    }
    /**
     * 内容浏览
     */
    public static function contentView (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentView(["contentId" => $contentId, ]);
    }
    /**
     * 发布内容
     */
    public static function contentAdd (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCMD): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentAdd($contentAddCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO"
        );
    }
    /**
     * 编辑内容
     */
    public static function contentUpdate (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentUpdate($contentUpdateCMD);
    }
    /**
     * 是否显示发布授权弹窗
     */
    public static function isShowAuthorizationLayer (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->isShowAuthorizationLayer(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO"
        );
    }
    /**
     * 同意圈圈授权
     */
    public static function agreeContentAuthorization (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->agreeContentAuthorization();
    }
    /**
     * 客片相册列表
     */
    public static function photoAlbumList (string $orderNum, int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumList(["orderNum" => $orderNum, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO"
        );
    }
    /**
     * 客片相册详情
     */
    public static function photoAlbumDetail (string $orderNum): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumDetail(["orderNum" => $orderNum, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO"
        );
    }
    /**
     * 清除新消息(红点)
     */
    public static function clearContentNewMessage (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearContentNewMessage();
    }
    /**
     * 我的圈圈列表
     */
    public static function myContentList (int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->myContentList(["page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 我点赞的圈圈列表
     */
    public static function userLikeContentList (int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userLikeContentList(["page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 圈圈-我的页面用户信息
     */
    public static function contentUserInfo (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentUserInfo(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO"
        );
    }
    /**
     * 圈圈-获取环境配置和横幅标题
     */
    public static function contentEnvConfig (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentEnvConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO"
        );
    }
    /**
     * 获取首页(新内容提示和待发布文案).v1
     */
    public static function userNewTipsV1 (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userNewTipsV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO"
        );
    }
    /**
     * 获取场景标签和文案提示.v1
     */
    public static function contentPublishConfigV1 (string $originPage = 'content_publish'): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentPublishConfigV1(["originPage" => $originPage, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO"
        );
    }
    /**
     * 内容搜索.v1
     */
    public static function contentSearchV1 (string $searchName, string $sortType, int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentSearchV1(["searchName" => $searchName, "sortType" => $sortType, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 获取官方发布内容列表 v1
     */
    public static function officialContentListV1 (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->officialContentListV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]"
        );
    }
    /**
     * 获取内容列表.v1
     */
    public static function contentListV1 (int $tagId, int $page = 1): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentListV1(["tagId" => $tagId, "page" => $page, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 获取内容详情.v1
     */
    public static function contentDetailV1 (int $contentId): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentDetailV1(["contentId" => $contentId, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }
    /**
     * 内容点赞.v1
     */
    public static function contentLikeV1 (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLikeV1(["contentId" => $contentId, ]);
    }
    /**
     * 内容取消点赞.v1
     */
    public static function contentLikeCancelV1 (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentLikeCancelV1(["contentId" => $contentId, ]);
    }
    /**
     * 用户当日关闭横幅.v1
     */
    public static function contentTipCloseV1 (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentTipCloseV1();
    }
    /**
     * 是否存在待发布订单.v1
     */
    public static function unreleasedOrderExistsV1 (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->unreleasedOrderExistsV1();
    }
    /**
     * 删除内容.v1
     */
    public static function contentDeleteV1 (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentDeleteV1(["contentId" => $contentId, ]);
    }
    /**
     * 内容分享.v1
     */
    public static function contentShareV1 (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentShareV1(["contentId" => $contentId, ]);
    }
    /**
     * 内容浏览.v1
     */
    public static function contentViewV1 (int $contentId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentViewV1(["contentId" => $contentId, ]);
    }
    /**
     * 发布内容.v1
     */
    public static function contentAddV1 (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCMD): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentAddV1($contentAddCMD),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO"
        );
    }
    /**
     * 编辑内容.v1
     */
    public static function contentUpdateV1 (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->contentUpdateV1($contentUpdateCMD);
    }
    /**
     * 是否显示发布授权弹窗.v1
     */
    public static function isShowAuthorizationLayerV1 (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->isShowAuthorizationLayerV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO"
        );
    }
    /**
     * 同意圈圈授权.v1
     */
    public static function agreeContentAuthorizationV1 (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->agreeContentAuthorizationV1();
    }
    /**
     * 客片相册列表.v1
     */
    public static function photoAlbumListV1 (string $orderNum, int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumListV1(["orderNum" => $orderNum, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO"
        );
    }
    /**
     * 客片相册详情v1
     */
    public static function photoAlbumDetailV1 (string $orderNum): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->photoAlbumDetailV1(["orderNum" => $orderNum, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO"
        );
    }
    /**
     * 清除新消息(红点).v1
     */
    public static function clearContentNewMessageV1 (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearContentNewMessageV1();
    }
    /**
     * 我的圈圈列表.v1
     */
    public static function myContentListV1 (int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->myContentListV1(["page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 我点赞的圈圈列表.v1
     */
    public static function userLikeContentListV1 (int $page = 1, int $pageSize = 10): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userLikeContentListV1(["page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }
    /**
     * 圈圈-我的页面用户信息.v1
     */
    public static function contentUserInfoV1 (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentUserInfoV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO"
        );
    }
    /**
     * 圈圈-获取环境配置和横幅标题.v1
     */
    public static function contentEnvConfigV1 (): \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contentEnvConfigV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentEnvConfigDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}