<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contentListByParams(array $params)
 * @method unreleasedActivityOrderExistsByParams(array $params)
 * @method contentActivityConfigByParams(array $params)
 * @method newYearActivityConfigByParams(array $params)
 */
class ContentActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 活动标签内容列表
     *
     * @support  string $sortType 排序类型 [ require false ]
     * @support  int $tagId 标签id [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function contentList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentList([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 待发布的活动订单是否存在
     *
     * @support  string $activityName 活动名称 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unreleasedActivityOrderExists () {
        return self::getClass()->unreleasedActivityOrderExists([
        ]);
    }

    /**
     * 童话季活动配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ContentActivityConfigDTO
     */
    public static function contentActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentActivityConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\ContentActivityConfigDTO"
        );
    }

    /**
     * 新年活动配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\NewYearActivityConfigDTO
     */
    public static function newYearActivityConfig () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->newYearActivityConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentActivity\NewYearActivityConfigDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'Content\ContentActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'Content\ContentActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}