<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Bridge;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contentTagListByParams(array $params)
 */
class ContentTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取场景标签.bridge
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCommunityTagDTO[]
     */
    public static function contentTagList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentTagList(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCommunityTagDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'Bridge\ContentTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'Bridge\ContentTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}