<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenProductUpdateByParams(array $params)
 * @method listenCategoryUpdateByParams(array $params)
 */
class ProductCache {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 编辑产品通知
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProductUpdate (int $productId) {
        return self::getClass()->listenProductUpdate([
            "productId" => $productId,
        ]);
    }

    /**
     * 编辑产品组通知
     *
     * @param  int $categoryId 产品组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenCategoryUpdate (int $categoryId) {
        return self::getClass()->listenCategoryUpdate([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'MessageQueue\ProductCache');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'MessageQueue\ProductCache');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}