<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenContentAuditFailedByParams(array $params)
 * @method listenContentSetStarByParams(array $params)
 * @method listenContentCancelStarByParams(array $params)
 * @method listenContentWaitStarByParams(array $params)
 * @method contentReviewCountStoreByParams(array $params)
 * @method listenContentStatusChangeByParams(array $params)
 * @method listenContentDeleteByParams(array $params)
 * @method listenAddTagContentIdsCacheByParams(array $params)
 */
class Content {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听内容审核失败
     *
     * @support  int $shareOrderId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentAuditFailed () {
        return self::getClass()->listenContentAuditFailed([
        ]);
    }

    /**
     * 监听内容被精选
     *
     * @support  int $shareOrderId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentSetStar () {
        return self::getClass()->listenContentSetStar([
        ]);
    }

    /**
     * 监听内容精选取消事件
     *
     * @support  int $shareOrderId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentCancelStar () {
        return self::getClass()->listenContentCancelStar([
        ]);
    }

    /**
     * 监听内容上架或审核通过
     *
     * @support  int $shareOrderId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentWaitStar () {
        return self::getClass()->listenContentWaitStar([
        ]);
    }

    /**
     * 监听内容浏览技术存储事件
     *
     * @param  array $contentIds 内容ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentReviewCountStore (array $contentIds) {
        return self::getClass()->contentReviewCountStore([
            "contentIds" => $contentIds,
        ]);
    }

    /**
     * 内容状态变更
     *
     * @param  int $shareOrderId 内容id [ require true ]
     * @param  string $status 内容状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentStatusChange (int $shareOrderId, string $status) {
        return self::getClass()->listenContentStatusChange([
            "shareOrderId" => $shareOrderId,
            "status" => $status,
        ]);
    }

    /**
     * 内容删除事件
     *
     * @param  int $shareOrderId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentDelete (int $shareOrderId) {
        return self::getClass()->listenContentDelete([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * 监听内容添加tag缓存
     *
     * @param  int $tagId 标签id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenAddTagContentIdsCache (int $tagId) {
        return self::getClass()->listenAddTagContentIdsCache([
            "tagId" => $tagId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'MessageQueue\Content');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'MessageQueue\Content');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}