<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contentListByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentListAdminCMD $params)
 * @method contentDetailByParams(array $params)
 * @method contentTagListByParams(array $params)
 * @method contentAddByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminAddCMD $params)
 * @method contentUpdateByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminUpdateCMD $params)
 * @method contentDeleteByParams(array $params)
 * @method contentCategoryListByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentCategoryListAdminCMD $params)
 * @method contentCategoryDetailByParams(array $params)
 * @method contentCategoryPhotoSetStarByParams(array $params)
 * @method contentManualAuditByParams(array $params)
 * @method contentUpByParams(array $params)
 * @method contentDownByParams(array $params)
 * @method contentAddSortWeightByParams(array $params)
 * @method contentCancelSortWeightByParams(array $params)
 */
class ContentAdmin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取内容列表
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentListAdminCMD $contentListAdminCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function contentList (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentListAdminCMD $contentListAdminCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentList($contentListAdminCmd),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }


    /**
     * 获取内容详情
     *
     * @support  int $contentId 内容id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO
     */
    public static function contentDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentDetail([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }

    /**
     * 获取场景标签
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCommunityTagDTO[]
     */
    public static function contentTagList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentTagList(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCommunityTagDTO[]"
        );
    }

    /**
     * 发布内容
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminAddCMD $contentAdminAddCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function contentAdd (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminAddCMD $contentAdminAddCmd) {
        return self::getClass()->contentAdd($contentAdminAddCmd);
    }


    /**
     * 更新内容
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminUpdateCMD $contentAdminUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function contentUpdate (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentAdminUpdateCMD $contentAdminUpdateCmd) {
        return self::getClass()->contentUpdate($contentAdminUpdateCmd);
    }


    /**
     * 删除内容
     *
     * @param  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentDelete (int $contentId) {
        return self::getClass()->contentDelete([
            "contentId" => $contentId,
        ]);
    }

    /**
     * 买家秀列表
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentCategoryListAdminCMD $contentCategoryListAdminCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryListDTO
     */
    public static function contentCategoryList (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\ContentAdmin\ContentCategoryListAdminCMD $contentCategoryListAdminCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentCategoryList($contentCategoryListAdminCmd),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryListDTO"
        );
    }


    /**
     * 买家秀详情
     *
     * @param  int $contentId 内容id [ require true ]
     * @param  int $categoryId 类目id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryDetailDTO
     */
    public static function contentCategoryDetail (int $contentId, int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentCategoryDetail([
                            "contentId" => $contentId,
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentCategoryDetailDTO"
        );
    }

    /**
     * 设置买家秀照片精选
     *
     * @support  int $contentId 内容id [ require true ]
     * @support  int $categoryId 产品组id [ require true ]
     * @support  array $starPhotos 精选的照片路径数组 [ require false ]
     * @support  int $staffId 操作人id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentCategoryPhotoSetStar () {
        return self::getClass()->contentCategoryPhotoSetStar([
        ]);
    }

    /**
     * 内容人工审核
     *
     * @support  int $contentId 内容id [ require true ]
     * @support  string $status 状态值 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentManualAudit () {
        return self::getClass()->contentManualAudit([
        ]);
    }

    /**
     * 内容上架
     *
     * @param  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentUp (int $contentId) {
        return self::getClass()->contentUp([
            "contentId" => $contentId,
        ]);
    }

    /**
     * 内容下架
     *
     * @param  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentDown (int $contentId) {
        return self::getClass()->contentDown([
            "contentId" => $contentId,
        ]);
    }

    /**
     * 内容加权
     *
     * @param  int $contentId 内容id [ require true ]
     * @param  int $sortWeight 排序值 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentAddSortWeight (int $contentId, int $sortWeight) {
        return self::getClass()->contentAddSortWeight([
            "contentId" => $contentId,
            "sortWeight" => $sortWeight,
        ]);
    }

    /**
     * 内容取消加权
     *
     * @param  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentCancelSortWeight (int $contentId) {
        return self::getClass()->contentCancelSortWeight([
            "contentId" => $contentId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'Content\ContentAdmin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'Content\ContentAdmin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}