<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contentSearchConfigByParams(array $params)
 * @method contentSearchTermsDeleteByParams(array $params)
 * @method contentSearchWordCreateByParams(array $params)
 * @method contentSearchConfigV1ByParams(array $params)
 * @method contentSearchTermsDeleteV1ByParams(array $params)
 * @method contentSearchWordCreateV1ByParams(array $params)
 */
class ContentSearch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取搜索词列表和热门搜索词列表配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO
     */
    public static function contentSearchConfig () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentSearchConfig(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO"
        );
    }

    /**
     * 批量删除搜索词
     *
     * @support  array $searchWordIds 搜索词ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentSearchTermsDelete () {
        return self::getClass()->contentSearchTermsDelete([
        ]);
    }

    /**
     * 添加搜索词
     *
     * @support  string $searchWord 搜索词名称 [ require true ]
     * @support  string $brand 搜索平台 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function contentSearchWordCreate () {
        return self::getClass()->contentSearchWordCreate([
        ]);
    }

    /**
     * 获取搜索词列表和热门搜索词列表配置.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO
     */
    public static function contentSearchConfigV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentSearchConfigV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentSearch\ContentSearchConfigDTO"
        );
    }

    /**
     * 批量删除搜索词 v1
     *
     * @support  array $searchWordIds 搜索词ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentSearchTermsDeleteV1 () {
        return self::getClass()->contentSearchTermsDeleteV1([
        ]);
    }

    /**
     * 添加搜索词 v1
     *
     * @support  string $searchWord 搜索词名称 [ require true ]
     * @support  string $brand 搜索平台 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function contentSearchWordCreateV1 () {
        return self::getClass()->contentSearchWordCreateV1([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'Content\ContentSearch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'Content\ContentSearch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}