<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Content;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userNewTipsByParams(array $params)
 * @method contentPublishConfigByParams(array $params)
 * @method contentSearchByParams(array $params)
 * @method officialContentListByParams(array $params)
 * @method contentListByParams(array $params)
 * @method contentDetailByParams(array $params)
 * @method contentLikeByParams(array $params)
 * @method contentLikeCancelByParams(array $params)
 * @method contentTipCloseByParams(array $params)
 * @method unreleasedOrderExistsByParams(array $params)
 * @method contentDeleteByParams(array $params)
 * @method contentShareByParams(array $params)
 * @method contentViewByParams(array $params)
 * @method contentAddByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $params)
 * @method contentUpdateByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $params)
 * @method isShowAuthorizationLayerByParams(array $params)
 * @method agreeContentAuthorizationByParams(array $params)
 * @method photoAlbumListByParams(array $params)
 * @method photoAlbumDetailByParams(array $params)
 * @method clearContentNewMessageByParams(array $params)
 * @method myContentListByParams(array $params)
 * @method userLikeContentListByParams(array $params)
 * @method contentUserInfoByParams(array $params)
 * @method userNewTipsV1ByParams(array $params)
 * @method contentPublishConfigV1ByParams(array $params)
 * @method contentSearchV1ByParams(array $params)
 * @method officialContentListV1ByParams(array $params)
 * @method contentListV1ByParams(array $params)
 * @method contentDetailV1ByParams(array $params)
 * @method contentLikeV1ByParams(array $params)
 * @method contentLikeCancelV1ByParams(array $params)
 * @method contentTipCloseV1ByParams(array $params)
 * @method unreleasedOrderExistsV1ByParams(array $params)
 * @method contentDeleteV1ByParams(array $params)
 * @method contentShareV1ByParams(array $params)
 * @method contentViewV1ByParams(array $params)
 * @method contentAddV1ByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $params)
 * @method contentUpdateV1ByParams(array|\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $params)
 * @method isShowAuthorizationLayerV1ByParams(array $params)
 * @method agreeContentAuthorizationV1ByParams(array $params)
 * @method photoAlbumListV1ByParams(array $params)
 * @method photoAlbumDetailV1ByParams(array $params)
 * @method clearContentNewMessageV1ByParams(array $params)
 * @method myContentListV1ByParams(array $params)
 * @method userLikeContentListV1ByParams(array $params)
 * @method contentUserInfoV1ByParams(array $params)
 */
class ContentCommunity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取首页(新内容提示和待发布文案)
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO
     */
    public static function userNewTips () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->userNewTips(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO"
        );
    }

    /**
     * 获取场景标签和文案提示
     *
     * @param  string $originPage 来源页面 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO
     */
    public static function contentPublishConfig (string $originPage = 'content_publish') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentPublishConfig([
                            "originPage" => $originPage,
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO"
        );
    }

    /**
     * 内容搜索
     *
     * @support  string $searchName 搜索名称 [ require true ]
     * @support  string $sortType 排序类型 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function contentSearch () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentSearch([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取官方发布内容列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]
     */
    public static function officialContentList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->officialContentList(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]"
        );
    }

    /**
     * 获取内容列表
     *
     * @support  int $tagId 标签id [ require false ]
     * @support  int $page 页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function contentList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentList([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取内容详情
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO
     */
    public static function contentDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentDetail([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }

    /**
     * 内容点赞
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentLike () {
        return self::getClass()->contentLike([
        ]);
    }

    /**
     * 内容取消点赞
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentLikeCancel () {
        return self::getClass()->contentLikeCancel([
        ]);
    }

    /**
     * 用户当日关闭横幅
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function contentTipClose () {
        return self::getClass()->contentTipClose();
    }

    /**
     * 是否存在待发布订单
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function unreleasedOrderExists () {
        return self::getClass()->unreleasedOrderExists();
    }

    /**
     * 删除内容
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentDelete () {
        return self::getClass()->contentDelete([
        ]);
    }

    /**
     * 内容分享
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentShare () {
        return self::getClass()->contentShare([
        ]);
    }

    /**
     * 内容浏览
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentView () {
        return self::getClass()->contentView([
        ]);
    }

    /**
     * 发布内容
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO
     */
    public static function contentAdd (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentAdd($contentAddCmd),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO"
        );
    }


    /**
     * 编辑内容
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function contentUpdate (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCmd) {
        return self::getClass()->contentUpdate($contentUpdateCmd);
    }


    /**
     * 是否显示发布授权弹窗
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO
     */
    public static function isShowAuthorizationLayer () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->isShowAuthorizationLayer(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO"
        );
    }

    /**
     * 同意圈圈授权
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function agreeContentAuthorization () {
        return self::getClass()->agreeContentAuthorization();
    }

    /**
     * 客片相册列表
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO
     */
    public static function photoAlbumList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photoAlbumList([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO"
        );
    }

    /**
     * 客片相册详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO
     */
    public static function photoAlbumDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photoAlbumDetail([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO"
        );
    }

    /**
     * 清除新消息(红点)
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function clearContentNewMessage () {
        return self::getClass()->clearContentNewMessage();
    }

    /**
     * 我的圈圈列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function myContentList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->myContentList([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 我点赞的圈圈列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function userLikeContentList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->userLikeContentList([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 圈圈-我的页面用户信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO
     */
    public static function contentUserInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentUserInfo(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO"
        );
    }

    /**
     * 获取首页(新内容提示和待发布文案).v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO
     */
    public static function userNewTipsV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->userNewTipsV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserNewTipsDTO"
        );
    }

    /**
     * 获取场景标签和文案提示.v1
     *
     * @param  string $originPage 来源页面 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO
     */
    public static function contentPublishConfigV1 (string $originPage = 'content_index') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentPublishConfigV1([
                            "originPage" => $originPage,
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentPublishConfigDTO"
        );
    }

    /**
     * 内容搜索.v1
     *
     * @support  string $searchName 搜索名称 [ require true ]
     * @support  string $sortType 排序类型 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function contentSearchV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentSearchV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取官方发布内容列表 v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]
     */
    public static function officialContentListV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->officialContentListV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\OfficialContentBaseDTO[]"
        );
    }

    /**
     * 获取内容列表.v1
     *
     * @support  int $tagId 标签id [ require false ]
     * @support  int $page 页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function contentListV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentListV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 获取内容详情.v1
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO
     */
    public static function contentDetailV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentDetailV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailDTO"
        );
    }

    /**
     * 内容点赞.v1
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentLikeV1 () {
        return self::getClass()->contentLikeV1([
        ]);
    }

    /**
     * 内容取消点赞.v1
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentLikeCancelV1 () {
        return self::getClass()->contentLikeCancelV1([
        ]);
    }

    /**
     * 用户当日关闭横幅.v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function contentTipCloseV1 () {
        return self::getClass()->contentTipCloseV1();
    }

    /**
     * 是否存在待发布订单.v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function unreleasedOrderExistsV1 () {
        return self::getClass()->unreleasedOrderExistsV1();
    }

    /**
     * 删除内容.v1
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentDeleteV1 () {
        return self::getClass()->contentDeleteV1([
        ]);
    }

    /**
     * 内容分享.v1
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentShareV1 () {
        return self::getClass()->contentShareV1([
        ]);
    }

    /**
     * 内容浏览.v1
     *
     * @support  int $contentId 内容id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function contentViewV1 () {
        return self::getClass()->contentViewV1([
        ]);
    }

    /**
     * 发布内容.v1
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO
     */
    public static function contentAddV1 (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentAddCMD $contentAddCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentAddV1($contentAddCmd),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentDetailBaseDTO"
        );
    }


    /**
     * 编辑内容.v1
     *
     * @var  \Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function contentUpdateV1 (\Mainto\Bridge\Structs\HimoContentCommunity\Cmd\Content\ContentUpdateCMD $contentUpdateCmd) {
        return self::getClass()->contentUpdateV1($contentUpdateCmd);
    }


    /**
     * 是否显示发布授权弹窗.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO
     */
    public static function isShowAuthorizationLayerV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->isShowAuthorizationLayerV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentAuthorizationLayerDTO"
        );
    }

    /**
     * 同意圈圈授权.v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function agreeContentAuthorizationV1 () {
        return self::getClass()->agreeContentAuthorizationV1();
    }

    /**
     * 客片相册列表.v1
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO
     */
    public static function photoAlbumListV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photoAlbumListV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumListDTO"
        );
    }

    /**
     * 客片相册详情v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO
     */
    public static function photoAlbumDetailV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->photoAlbumDetailV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\PhotoAlbumDetailDTO"
        );
    }

    /**
     * 清除新消息(红点).v1
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function clearContentNewMessageV1 () {
        return self::getClass()->clearContentNewMessageV1();
    }

    /**
     * 我的圈圈列表.v1
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function myContentListV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->myContentListV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 我点赞的圈圈列表.v1
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条页 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO
     */
    public static function userLikeContentListV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->userLikeContentListV1([
                        ]),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentListDTO"
        );
    }

    /**
     * 圈圈-我的页面用户信息.v1
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO
     */
    public static function contentUserInfoV1 () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->contentUserInfoV1(),
            "\Mainto\Bridge\Structs\HimoContentCommunity\DTO\ContentCommunity\ContentUserInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'Content\ContentCommunity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'Content\ContentCommunity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}