<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenOrderFinishedByParams(array $params)
 * @method listenOrderRetakeSaleSkuByParams(array $params)
 * @method listenOrderPartRefundByParams(array $params)
 * @method listenOrderRefundByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听订单拍摄完成事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderFinished (int $orderId) {
        return self::getClass()->listenOrderFinished([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 监听订单重拍事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderRetakeSaleSku (int $orderId) {
        return self::getClass()->listenOrderRetakeSaleSku([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 监听订单部分退款事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderPartRefund (int $orderId) {
        return self::getClass()->listenOrderPartRefund([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 监听订单拍摄完成事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenOrderRefund (int $orderId) {
        return self::getClass()->listenOrderRefund([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'MessageQueue\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'MessageQueue\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}