<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contentViewCountStoreByParams(array $params)
 * @method hotTagContentIdsCacheByParams(array $params)
 */
class Content {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每小时40分调用一次 把浏览计数刷回数据库
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function contentViewCountStore () {
        return self::getClass()->contentViewCountStore();
    }

    /**
     * 每20分钟调用一次 更新下缓存数据
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hotTagContentIdsCache () {
        return self::getClass()->hotTagContentIdsCache();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'Cron\Content');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'Cron\Content');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}