<?php
namespace Mainto\Bridge\Invokes\HimoContentCommunity\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenContentLikeByParams(array $params)
 * @method listenContentShareByParams(array $params)
 * @method listenContentAuditFailedByParams(array $params)
 * @method listenContentSetStarByParams(array $params)
 * @method listenContentCancelStarByParams(array $params)
 * @method listenContentCancelLikeByParams(array $params)
 * @method listenContentUpByParams(array $params)
 */
class Content {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听用户点赞事件
     *
     * @support  int $contentId 内容id [ require false ]
     * @support  int $contentUserId 内容用户id [ require false ]
     * @support  int $userId 点赞用户的id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentLike () {
        return self::getClass()->listenContentLike([
        ]);
    }

    /**
     * 监听用户分享事件
     *
     * @support  int $contentId 内容id [ require false ]
     * @support  int $contentUserId 内容用户id [ require false ]
     * @support  int $userId 分享用户的id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentShare () {
        return self::getClass()->listenContentShare([
        ]);
    }

    /**
     * 监听内容审核失败
     *
     * @support  int $contentId 内容id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentAuditFailed () {
        return self::getClass()->listenContentAuditFailed([
        ]);
    }

    /**
     * 监听内容被精选
     *
     * @support  int $contentId 内容id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentSetStar () {
        return self::getClass()->listenContentSetStar([
        ]);
    }

    /**
     * 监听内容精选取消事件
     *
     * @support  int $contentId 内容id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentCancelStar () {
        return self::getClass()->listenContentCancelStar([
        ]);
    }

    /**
     * 监听内容点赞取消事件
     *
     * @support  int $contentId 内容id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentCancelLike () {
        return self::getClass()->listenContentCancelLike([
        ]);
    }

    /**
     * 监听内容上架事件
     *
     * @support  int $contentId 内容id [ require false ]
     * @support  string $oldStatus 内容变更前的状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenContentUp () {
        return self::getClass()->listenContentUp([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoContentCommunity', 'MessageQueue\Content');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoContentCommunity', 'MessageQueue\Content');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}