<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-22 14:08:07
 */
namespace Mainto\Bridge\Invokes\HimoAggregateOrder\AggregateOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AggregateOrderSearch
 */
class AggregateOrderSearch {
    private static string $serviceName = "HimoAggregateOrder";

    private static string $className = "AggregateOrder\\AggregateOrderSearch";

    /**
     * 根据订单编号和类型查询聚合订单编号
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateOrderNoDTO
    */
    public static function getAggregateOrderNo (string $outOrderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregateOrderNo(["outOrderNo" => $outOrderNo]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateOrderNoDTO"
        );
    }
    /**
     * 根据聚合订单获取订单列表
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateWithSubOrderNosDTO
    */
    public static function getAggregateSubOrderNos (string $aggregateOrderNo, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregateSubOrderNos(["aggregateOrderNo" => $aggregateOrderNo, "withDeleted" => $withDeleted]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrderSearch\AggregateWithSubOrderNosDTO"
        );
    }
    /**
     * 获取聚合订单详情
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO
    */
    public static function detail (string $aggregateOrderNo, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["aggregateOrderNo" => $aggregateOrderNo, "withDeleted" => $withDeleted]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO"
        );
    }
    /**
     * 通过外部订单号获取聚合订单详情
     * @return  \Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO
    */
    public static function getAggregateOrderInfo (string $outOrderNo, bool $withSubOrder = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAggregateOrderInfo(["outOrderNo" => $outOrderNo, "withSubOrder" => $withSubOrder]),
            "\Mainto\Bridge\Structs\HimoAggregateOrder\AggregateOrder\DTO\AggregateOrder\AggregateOrderDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}